// enumerations for states, triggers, guards and effects

enum {
    STATES( STATE_ENUM_ITEM )
};

enum {
    TRIGGERS( TRIGGER_ENUM_ITEM )
};

enum {
    GUARDS( GUARD_ENUM_ITEM )
};

enum {
    EFFECTS( EFFECT_ENUM_ITEM )
};

// prototype functions for guards and effects
GUARDS( GUARD_PROTOTYPE_ITEM )

EFFECTS( EFFECT_PROTOTYPE_ITEM )

static bool guardHandler(uint8_t guard) {
    switch( guard ) {
        GUARDS( GUARD_CASE_ITEM )
        default : return true;
    }
}

static void effectHandler(uint8_t effect) {
    switch( effect ) {
        EFFECTS( EFFECT_CASE_ITEM )
        default : break;
    }
}

static void applyTrigger(const uint8_t trigger) {

    static const statemachineRule_t rules[] = {
    	STATEMACHINE
    };

    static statemachine_t statemachine = {
        guardHandler     ,
        effectHandler    ,
        rules            ,
        ARRAY_SIZE(rules),
        INITIAL_STATE
    };

    statemachine_ApplyTrigger(&statemachine, trigger);
}
